<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/TR/WD-xsl">

 <xsl:template match="/">
  <html>
    <head>
     <title> RAD modems</title>
      <Style>
	h2 {COLOR:blue; FONT-FAMILY:'Arial Narrow'; TEXT-ALIGN:center;  
                        FONT-SIZE:x-large; FONT-STYLE:italic}
	th {BACKGROUND-COLOR: Lavender; COLOR: Indigo ;FONT-SIZE:small}
	td {COLOR: Indigo}
      </Style>
     </head>

     <body>
    	<xsl:apply-templates select="modems"/>
     </body>
    </html>
 </xsl:template>
	
 <xsl:template match="modems">
   
  <p align="CENTER"><h2>COPPER and FIBER-OPTIC MODEMS</h2></p>
  <table border="1" cellpadding="8" cellspacing="1">
    <th>name</th>
    <th>medium
        <select name="medium" onClick="selectmedium(this.value)">
          <option selected="selected" value="any" >any</option>
          <option value="copper">copper</option>
          <option value="2-wire">2-wire</option>
          <option value="4-wire">4-wire</option>
          <option value="fiber">fiber</option>
          <option value="single-mode">single-mode</option>
          <option value="multi-mode">multi-mode</option>
        </select> 
    </th>    
    <th>NMS
        <select name="NMS" onClick="selectman(this.value)">
          <option value="either" selected="true">either</option>
          <option value="managed">managed</option>
          <option value="unmanaged">unmanaged</option>
        </select> 
    </th>
    <th>rate
       <input type="text" name="rate" size="5" maxlength="5" value="0"
        onChange="inputrate(this.value)"/>Kbps 
    </th>
    <th>range
       <input type="text" name="range" size="5" maxlength="5" value="0"
        onChange="inputrange(this.value)"/>Km 
    </th>
    <th>interfaces</th>

    <xsl:for-each select="copper|fiber" order-by="number(minrate)">
     <xsl:if test=".[medium='2-wire' or medium='4-wire' or medium='single-mode' 
                  or medium='multi-mode']" id="testmedium">
     <xsl:if test=".[management='managed' or management='unmanaged']" id="testman">
     <xsl:if test=".[number(0) &lt; number(maxrate)]"
             id="testrate">
     <xsl:if test=".[number(maxrange) >= 0]" id="testrange">
     <tr>
       <td><a><xsl:attribute name="href">
           http://www.rad.co.il/<xsl:value-of select="webpage"/>
           </xsl:attribute><xsl:value-of select="name"/></a>
       </td>
       <td>
          <xsl:for-each select="medium">
            <xsl:value-of select="."/>
          </xsl:for-each>
       </td>       
       <td><xsl:value-of select="management"/></td>
       <td>
           <xsl:if test=".[number(minrate) &lt; number(maxrate)]">
             <xsl:value-of select="minrate"/>-<xsl:value-of select="maxrate"/>
           </xsl:if>
           <xsl:if test=".[minrate=maxrate]">
             <xsl:value-of select="minrate"/>
           </xsl:if>
       </td>
       <td><xsl:value-of select="maxrange"/> km</td>
       <td><xsl:value-of select="interfaces"/></td>
      </tr>
     </xsl:if></xsl:if></xsl:if></xsl:if>
    </xsl:for-each>
  </table>

  </xsl:template>	

</xsl:stylesheet>	
	